<?php
session_start();
@date_default_timezone_set('Asia/Pontianak');

$koneksi = new mysqli('localhost', 'root', '', 'klinik');


if (!isset($_SESSION['username'])) {
    header("Location: users.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['tambah'])) {
    $nama = $_POST['nama_obat'];
    $fungsi = $_POST['fungsi_obat'];
    $koneksi->query("INSERT INTO data_obat (nama_obat, fungsi_obat) VALUES ('$nama', '$fungsi')");
    header("Location: data-obat.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_simpan'])) {
    $id = $_POST['id'];
    $nama = $_POST['nama_obat'];
    $fungsi = $_POST['fungsi_obat'];
    $koneksi->query("UPDATE data_obat SET nama_obat='$nama', fungsi_obat='$fungsi' WHERE id=$id");
    header("Location: data-obat.php");
    exit;
}

if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    $koneksi->query("DELETE FROM data_obat WHERE id=$id");
    header("Location: data-obat.php");
    exit;
}

$edit_data = null;
if (isset($_GET['edit'])) {
    $id_edit = $_GET['edit'];
    $result = $koneksi->query("SELECT * FROM data_obat WHERE id = $id_edit");
    if ($result && $result->num_rows > 0) {
        $edit_data = $result->fetch_assoc();
    }
}

$data = $koneksi->query("SELECT * FROM data_obat ORDER BY id DESC");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Data Obat</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f9f9f9;
        }

        h2 {
            text-align: center;
        }
        .back-btn { 
            padding: 10px 20px; 
            color: white; 
            border-radius: 6px; 
            text-decoration: none;
            background: #6a1b9a;
            
        } 

        .form-container {
            max-width: 350px;
            margin: 0 auto 30px;
            padding: 20px;
            background-color: #fff;
            border: 1px solid #ccc;
            border-radius: 10px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .form-container input[type="text"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 12px;
            border: 1px solid #ccc;
            border-radius: 6px;
            box-sizing: border-box;
            font-size: 14px;
        }

        .form-container .btn {
            width: 100%;
            padding: 10px;
            border: none;
            border-radius: 6px;
            font-weight: bold;
            font-size: 14px;
            cursor: pointer;
        }

        .simpan {
            background-color: #169b28ff;
            color: white;
        }

        .batal {
            background-color: #ccc;
            color: black;
            margin-top: 8px;
            display: inline-block;
            text-align: center;
            padding: 10px;
            width: 100%;
            text-decoration: none;
            border-radius: 6px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            border: 1px solid #999;
            padding: 8px;
            text-align: center;
        }

        th {
            background-color: #116820ff;
            color: white;
        }

        .btn.edit {
            background: #f57c00; 
            color: #fff; 
            padding: 5px 10px; 
            border-radius: 4px; 
            text-decoration: none; 
        }

        .btn.hapus { 
            background: #d32f2f;
            color: #fff; 
            padding: 5px 10px; 
            border-radius: 4px;
            text-decoration: none; 
        }
    </style>
</head>
<body>
    <a href="home.php" class="back-btn">🏠 Kembali</a>

    <h2>Daftar Nama Obat dan Fungsinya</h2>

    <div class="form-container">
        <form method="POST">
            <input type="hidden" name="id" value="<?= $edit_data ? $edit_data['id'] : '' ?>">
            
            <input type="text" name="nama_obat" placeholder="Nama Obat" value="<?= $edit_data ? htmlspecialchars($edit_data['nama_obat']) : '' ?>" required>
            
            <input type="text" name="fungsi_obat" placeholder="Kegunaan" value="<?= $edit_data ? htmlspecialchars($edit_data['fungsi_obat']) : '' ?>" required>
            
            <?php if ($edit_data): ?>
                <button type="submit" name="edit_simpan" class="btn simpan">Simpan</button>
                <a href="data-obat.php" class="batal">Batal</a>
            <?php else: ?>
                <button type="submit" name="tambah" class="btn simpan">Simpan</button>
            <?php endif; ?>
        </form>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Obat</th>
                <th>Fungsi Obat</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $no=1; while ($row = $data->fetch_assoc()): ?>
            <tr>
                <td><?= $no++ ?></td>
                <td><?= htmlspecialchars($row['nama_obat']) ?></td>
                <td><?= htmlspecialchars($row['fungsi_obat']) ?></td>
                <td>
                    <a href="data-obat.php?edit=<?= $row['id'] ?>" class="btn edit">Edit</a>
                    <a href="data-obat.php?hapus=<?= $row['id'] ?>" class="btn hapus" onclick="return confirm('Yakin ingin hapus data ini?')">Hapus</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

</body>
</html>
